/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt;

import com.ibm.hwmca.fw.servlet.pmod.impl.ResourceLoaderResult;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.auimlcvt.DocumentInputStream;
import com.ibm.hwmca.fw.util.auimlcvt.OutputXML;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.AUIMLTagFactory;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.tags.AbstractAuimlTag;
import com.ibm.hwmca.fw.util.auimlcvt.auiml.tags.TagUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AUIMLParser {
    private String fileSpec;
    private String inResourceFile;
    private String desiredPanel;
    private Document auimlDocument;
    private Document hmcmlDocument;
    private ResourceBundle properties;
    private ResourceBundle fdaProperties;
    private static AUIMLTagFactory factory = new AUIMLTagFactory();
    private DocumentBuilder parser;
    private Properties utmProps;
    private static final String TRACE_MASKD = "XCVTAPSD";
    private static final String TRACE_MASKF = "XCVTAPSF";
    private static final String TRACE_MASKT = "XCVTAPST";
    public static boolean buildFDAProperties = true;
    public static boolean addFDAText = true;
    public static Map resourceMap = new HashMap();

    public AUIMLParser(String fileSpec, String desiredPanel) {
        this(fileSpec, desiredPanel, null);
    }

    public AUIMLParser(String fileSpec, String desiredPanel, Properties utmProps) {
        this(fileSpec);
        this.desiredPanel = desiredPanel;
        this.utmProps = utmProps;
        if (utmProps != null && utmProps.keySet().size() > 0) {
            Iterator<Object> iterator = utmProps.keySet().iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o == null) continue;
                Trace.trace(TRACE_MASKF, "utmProps[" + o + "]=" + utmProps.get(o));
            }
        }
    }

    public AUIMLParser(String fileSpec) {
        this.fileSpec = fileSpec;
    }

    private void init() throws Exception {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        this.parser = dFactory.newDocumentBuilder();
        String inAUIMLFile = this.fileSpec.replace('.', File.separatorChar) + ".auiml";
        this.auimlDocument = this.parser.parse(ClassLoader.getSystemResourceAsStream(inAUIMLFile));
        this.inResourceFile = this.fileSpec.replace(File.separatorChar, '.');
        this.properties = ResourceBundle.getBundle(this.inResourceFile);
        try {
            this.fdaProperties = ResourceBundle.getBundle(this.inResourceFile + "_FDA");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        resourceMap.put(this.inResourceFile, this.properties);
        if (this.fdaProperties == null) {
            resourceMap.put(this.inResourceFile + "FDA", new Properties());
        } else {
            resourceMap.put(this.inResourceFile + "FDA", this.fdaProperties);
        }
    }

    public ResourceLoaderResult parse() throws Exception {
        this.init();
        NodeList panelNodes = this.auimlDocument.getElementsByTagName("DATA-GROUP");
        int panelNodesLength = panelNodes.getLength();
        for (int i = 0; i < panelNodesLength; ++i) {
            if (!((Element)panelNodes.item(i)).getAttribute("NAME").equals(this.desiredPanel)) continue;
            this.hmcmlDocument = this.parser.newDocument();
            Element html = this.hmcmlDocument.createElement("html");
            Element meta = this.hmcmlDocument.createElementNS("acvt", "Meta");
            Element structure = this.hmcmlDocument.createElementNS("acvt", "DocStructure");
            this.hmcmlDocument.appendChild(html);
            html.appendChild(meta);
            meta.appendChild(structure);
            this.outputNodeAsHMCML((Element)panelNodes.item(i));
            TagUtils.removeEmptyRowsFromTables(this.hmcmlDocument);
            ResourceLoaderResult resourceLoaderResult = new ResourceLoaderResult(this.fileSpec, new DocumentInputStream(this.hmcmlDocument));
            resourceMap.remove(this.inResourceFile);
            return resourceLoaderResult;
        }
        throw new Exception("Panel [" + this.desiredPanel + "] not found in resource [" + this.fileSpec + "]");
    }

    public String[] findDataGroupNames() {
        try {
            this.init();
            NodeList panelNodes = this.auimlDocument.getElementsByTagName("DATA-GROUP");
            String[] names = new String[panelNodes.getLength()];
            int panelNodesLength = panelNodes.getLength();
            for (int i = 0; i < panelNodesLength; ++i) {
                names[i] = ((Element)panelNodes.item(i)).getAttribute("NAME");
            }
            return names;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    private void outputAllPanelsAsHMCML() throws Exception {
        this.init();
        NodeList panelNodes = this.auimlDocument.getElementsByTagName("DATA-GROUP");
        int panelNodesLength = panelNodes.getLength();
        for (int i = 0; i < panelNodesLength; ++i) {
            this.hmcmlDocument = this.parser.newDocument();
            Element html = this.hmcmlDocument.createElement("html");
            Element meta = this.hmcmlDocument.createElementNS("acvt", "Meta");
            Element structure = this.hmcmlDocument.createElementNS("acvt", "DocStructure");
            this.hmcmlDocument.appendChild(html);
            html.appendChild(meta);
            meta.appendChild(structure);
            String tmpPanelName = ((Element)panelNodes.item(i)).getAttribute("NAME");
            String outFile = this.fileSpec.replace('.', File.separatorChar);
            outFile = outFile + "$" + tmpPanelName + "_en_US.hmcml";
            try {
                this.outputNodeAsHMCML((Element)panelNodes.item(i));
                if (buildFDAProperties) continue;
                TagUtils.removeEmptyRowsFromTables(this.hmcmlDocument);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(outFile)));
                OutputXML.outputXML(bos, this.hmcmlDocument.getDocumentElement());
                bos.flush();
                bos.close();
                continue;
            }
            catch (Exception e) {
                System.err.println("In resource: " + this.fileSpec);
                System.err.println("Error converting panel: " + tmpPanelName);
                e.printStackTrace();
                OutputXML.printXML(this.hmcmlDocument.getDocumentElement());
            }
        }
        if (buildFDAProperties) {
            String outFile = this.fileSpec.replace('.', File.separatorChar);
            outFile = outFile + "_FDA.properties";
            Object o = resourceMap.get(this.inResourceFile + "FDA");
            if (o instanceof Properties) {
                Properties p = (Properties)o;
                p.store(new BufferedOutputStream(new FileOutputStream(new File(outFile))), "");
            }
        }
    }

    private String getResource(String key) {
        String additionalProperties;
        Object o;
        String returnString = "";
        try {
            returnString = this.properties.getString(key);
            if (returnString == null) {
                returnString = "";
            }
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (this.utmProps != null && (o = this.utmProps.get(key)) != null && o instanceof String && !(additionalProperties = ((String)o).trim()).equals("")) {
            Trace.trace(TRACE_MASKF, "overriding properties for \"" + key + "\": " + additionalProperties);
            returnString = additionalProperties.endsWith(";") ? additionalProperties + returnString : additionalProperties + ";" + returnString;
        }
        return returnString;
    }

    private String getContainingPanelName(Element element) {
        Element tmp = element;
        while (tmp != null) {
            if (tmp.getTagName().equals("DATA-GROUP")) {
                return tmp.getAttribute("NAME");
            }
            if (tmp.getParentNode() instanceof Element) {
                tmp = (Element)tmp.getParentNode();
                continue;
            }
            tmp = null;
        }
        return "";
    }

    private void outputNodeAsHMCML(Element element) throws Exception {
        this.outputNodeAsHMCML(element, null, null);
    }

    private void outputNodeAsHMCML(Element element, Element hmcmlMountPoint, AbstractAuimlTag parentAuimlTag) throws Exception {
        AbstractAuimlTag elementTag;
        String[] resources;
        String panelName = this.getContainingPanelName(element);
        if (element.getTagName().equals("CAPTION")) {
            String parentName = ((Element)element.getParentNode()).getAttribute("NAME");
            resources = new String[]{this.getResource("@" + panelName + "." + parentName), this.getResource("@" + panelName), this.getResource("@" + panelName + ".CAPTION"), "RSC-NAME:" + this.inResourceFile, "PANEL-NAME:" + panelName};
            elementTag = factory.getTag(element, this.hmcmlDocument, this.getResource("@" + panelName + "." + parentName + ".CAPTION"), resources);
        } else {
            resources = new String[]{this.getResource("@" + panelName + "." + element.getAttribute("NAME") + ".CAPTION"), this.getResource("@" + panelName), this.getResource("@" + panelName + ".CAPTION"), "RSC-NAME:" + this.inResourceFile, "PANEL-NAME:" + panelName};
            elementTag = factory.getTag(element, this.hmcmlDocument, this.getResource("@" + panelName + "." + element.getAttribute("NAME")), resources);
        }
        if (elementTag != null) {
            elementTag.setHmcmlMountPoint(hmcmlMountPoint);
            elementTag.startHMCMLTag();
            elementTag.adjustTag();
            if (parentAuimlTag != null) {
                elementTag.setMetaParent(parentAuimlTag.getMetaPlacement());
            }
            if (element.hasChildNodes()) {
                NodeList children = element.getChildNodes();
                int size = children.getLength();
                boolean traversed = false;
                for (int i = 0; i < size; ++i) {
                    Node kid = children.item(i);
                    if (!(kid instanceof Element)) continue;
                    traversed = true;
                    this.outputNodeAsHMCML((Element)kid, elementTag.getHmcmlElement(), elementTag);
                }
                if (!traversed) {
                    elementTag.getMetaPlacement();
                }
            } else if (element.getTagName().equals("INCLUDE")) {
                String desiredElement;
                if (element.getParentNode() instanceof Element && (((Element)element.getParentNode()).getTagName().equals("DATA-GROUP") || ((Element)element.getParentNode()).getTagName().equals("GROUP"))) {
                    desiredElement = element.getAttribute("ITEM-NAME");
                    desiredElement = desiredElement.substring("auiml://".length(), desiredElement.length());
                    NodeList panelNodes = this.auimlDocument.getElementsByTagName("DATA-GROUP");
                    String currentPanelName = null;
                    Element panelTag = null;
                    int i = 0;
                    do {
                        panelTag = (Element)panelNodes.item(i);
                        currentPanelName = panelTag.getAttribute("NAME");
                        ++i;
                    } while (!currentPanelName.equals(desiredElement));
                    Element parentAuimlElement = (Element)element.getParentNode();
                    String parentName = parentAuimlElement.getAttribute("NAME");
                    boolean found = false;
                    if (((Element)element.getParentNode()).getTagName().equals("DATA-GROUP")) {
                        NodeList wizardList = this.hmcmlDocument.getElementsByTagNameNS("wcl", "WWizard");
                        int wizardListLength = wizardList.getLength();
                        for (i = 0; i < wizardListLength; ++i) {
                            if (!((Element)wizardList.item(i)).getAttributeNS("hmc", "id").equals(parentName)) continue;
                            found = true;
                            Element wWizardStep = this.hmcmlDocument.createElementNS("wcl", "WWizardStep");
                            wWizardStep.setAttributeNS("hmc", "id", element.getAttribute("NAME"));
                            ((Element)wizardList.item(i)).appendChild(wWizardStep);
                            this.outputNodeAsHMCML(panelTag, wWizardStep, elementTag);
                            i = wizardList.getLength();
                            NodeList nl = wWizardStep.getChildNodes();
                            int nlLength = nl.getLength();
                            for (int j = 0; j < nlLength; ++j) {
                                if (!(nl.item(j) instanceof Element)) continue;
                                this.adjustHmcIdPrefixes((Element)nl.item(j), element.getAttribute("NAME") + ".");
                            }
                        }
                    } else {
                        NodeList notebookList = this.hmcmlDocument.getElementsByTagNameNS("wcl", "WNotebook");
                        int notebookListLength = notebookList.getLength();
                        for (i = 0; i < notebookListLength; ++i) {
                            if (!((Element)notebookList.item(i)).getAttributeNS("hmc", "id").equals(parentName)) continue;
                            found = true;
                            Element wNotebookPage = this.hmcmlDocument.createElementNS("wcl", "WNotebookPage");
                            wNotebookPage.setAttributeNS("hmc", "id", element.getAttribute("NAME"));
                            ((Element)notebookList.item(i)).appendChild(wNotebookPage);
                            this.outputNodeAsHMCML(panelTag, wNotebookPage, elementTag);
                            i = notebookList.getLength();
                            NodeList nl = wNotebookPage.getChildNodes();
                            int nlLength = nl.getLength();
                            for (int j = 0; j < nlLength; ++j) {
                                if (!(nl.item(j) instanceof Element)) continue;
                                this.adjustHmcIdPrefixes((Element)nl.item(j), element.getAttribute("NAME") + ".");
                            }
                        }
                        if (!found) {
                            NodeList cardLayoutList = this.hmcmlDocument.getElementsByTagNameNS("hmc", "CardLayout");
                            int cardLayoutListLength = cardLayoutList.getLength();
                            for (i = 0; i < cardLayoutListLength; ++i) {
                                if (!((Element)cardLayoutList.item(i)).getAttribute("id").equals(parentName)) continue;
                                found = true;
                                Element card = this.hmcmlDocument.createElementNS("hmc", "Card");
                                card.setAttribute("id", element.getAttribute("NAME"));
                                ((Element)cardLayoutList.item(i)).appendChild(card);
                                this.outputNodeAsHMCML(panelTag, card, elementTag);
                                i = cardLayoutList.getLength();
                                NodeList nl = card.getChildNodes();
                                int nlLength = nl.getLength();
                                for (int j = 0; j < nlLength; ++j) {
                                    if (!(nl.item(j) instanceof Element)) continue;
                                    this.adjustHmcIdPrefixes((Element)nl.item(j), element.getAttribute("NAME") + ".");
                                }
                            }
                        }
                        if (!found) {
                            NodeList tableList = this.hmcmlDocument.getElementsByTagName("table");
                            int tableListLength = tableList.getLength();
                            for (i = 0; i < tableListLength; ++i) {
                                if (!((Element)tableList.item(i)).getAttribute("name").equals(parentName)) continue;
                                this.outputNodeAsHMCML(panelTag, (Element)tableList.item(i), elementTag);
                                NodeList nl = ((Element)tableList.item(i)).getChildNodes();
                                int nlLength = nl.getLength();
                                for (int j = 0; j < nlLength; ++j) {
                                    if (!(nl.item(j) instanceof Element) || !((Element)nl.item(j)).getTagName().equals("table") || !((Element)nl.item(j)).getAttributeNS("hmc", "id").equals(element.getAttribute("NAME"))) continue;
                                    NodeList kids = ((Element)nl.item(j)).getChildNodes();
                                    int kidsLength = kids.getLength();
                                    for (int z = 0; z < kidsLength; ++z) {
                                        if (!(kids.item(z) instanceof Element)) continue;
                                        this.adjustHmcIdPrefixes((Element)kids.item(z), element.getAttribute("NAME") + ".");
                                    }
                                }
                            }
                        }
                    }
                } else if (!((Element)element.getParentNode()).getTagName().equals("TREE")) {
                    desiredElement = element.getAttribute("ITEM-NAME");
                    desiredElement = desiredElement.substring("auiml://".length(), desiredElement.length());
                    NodeList panelNodes = this.auimlDocument.getElementsByTagName("ACTION-GROUP");
                    String currentPanelName = null;
                    Element panelTag = null;
                    int i = 0;
                    do {
                        panelTag = (Element)panelNodes.item(i);
                        currentPanelName = panelTag.getAttribute("NAME");
                        ++i;
                    } while (!currentPanelName.equals(desiredElement));
                    String nickName = element.getAttribute("NAME");
                    String realName = panelTag.getAttribute("NAME");
                    panelTag.setAttribute("NAME", nickName);
                    this.outputNodeAsHMCML(panelTag, hmcmlMountPoint, elementTag);
                    panelTag.setAttribute("NAME", realName);
                }
            } else {
                elementTag.getMetaPlacement();
            }
            elementTag.endHMCMLTag();
        }
    }

    private void adjustHmcIdPrefixes(Element root, String prefixToAdd) {
        String oldId;
        String id;
        if (prefixToAdd == null || prefixToAdd.equals("")) {
            return;
        }
        if (root.getNamespaceURI() != null && root.getNamespaceURI().equals("hmc")) {
            oldId = id = root.getAttribute("id");
            if (id != null && !id.equals("")) {
                root.setAttribute("id", prefixToAdd + id);
            }
            if (root.getTagName().equals("FloatingLabel")) {
                root.setAttribute("for", prefixToAdd + root.getAttribute("for"));
            } else if (root.getTagName().equals("ChangeState")) {
                root.setAttribute("targetid", prefixToAdd + root.getAttribute("targetid"));
            }
        } else {
            oldId = id = root.getAttributeNS("hmc", "id");
            if (id != null && !id.equals("")) {
                root.setAttributeNS("hmc", "id", prefixToAdd + id);
            }
            if (root.getNamespaceURI() != null && root.getNamespaceURI().equals("acvt")) {
                if (root.getTagName().equals("RadioButton") || root.getTagName().equals("CheckBox")) {
                    String choice = root.getAttribute("choiceName");
                    root.setAttribute("choiceName", prefixToAdd + root.getAttribute("choiceName"));
                } else if (root.getTagName().equals("TableModel")) {
                    root.setAttributeNS("hmc", "model_id", prefixToAdd + root.getAttributeNS("hmc", "model_id"));
                }
            } else if (root.getNamespaceURI() != null && root.getNamespaceURI().equals("wcl") && root.getTagName().equals("WTable")) {
                root.setAttributeNS("hmc", "model", prefixToAdd + root.getAttributeNS("hmc", "model"));
            }
        }
        NodeList docStructure = root.getOwnerDocument().getDocumentElement().getElementsByTagNameNS("acvt", "DocStructure");
        int docStructureLength = docStructure.getLength();
        for (int i = 0; i < docStructureLength; ++i) {
            if (!(docStructure.item(i) instanceof Element)) continue;
            NodeList nodes = ((Element)docStructure.item(i)).getElementsByTagNameNS("acvt", "Node");
            int nodesLength = nodes.getLength();
            for (int z = 0; z < nodesLength; ++z) {
                if (!(nodes.item(z) instanceof Element) || !((Element)nodes.item(z)).getAttribute("id").equals(oldId)) continue;
                ((Element)nodes.item(z)).setAttribute("id", prefixToAdd + oldId);
                z = nodes.getLength();
                i = docStructure.getLength();
            }
        }
        NodeList nl = root.getChildNodes();
        int nlLength = nl.getLength();
        for (int i = 0; i < nlLength; ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            this.adjustHmcIdPrefixes((Element)nl.item(i), prefixToAdd);
        }
    }

    private static void usageExit() {
        System.out.println("Usage:\n\n java AUIMLParser <AUIML file prefix> [fda]\n\nExample:  java AUIMLParser com.ibm.hwmca.test.util.auimlcvt.PanelTests fda");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length > 2) {
            AUIMLParser.usageExit();
        }
        if (args.length == 2 && !args[1].equalsIgnoreCase("fda")) {
            AUIMLParser.usageExit();
        }
        try {
            AUIMLParser auimlParser = new AUIMLParser(args[0]);
            buildFDAProperties = args.length == 2;
            auimlParser.outputAllPanelsAsHMCML();
        }
        catch (Exception e) {
            System.err.println("Error converting AUIML file: " + args[0]);
            e.printStackTrace();
        }
    }
}

